package org.msh.etbm.services.mobile.model;

import org.msh.tb.entities.enums.*;
import org.msh.tb.ng.entities.enums.HIVPosition;
import org.msh.tb.ng.entities.enums.HIVPositionDetail;
import org.msh.tb.ng.entities.enums.IntakeAntiDrugsDuration;

import java.util.Date;

/**
 * Created by rmemoria on 8/3/17.
 */
public class TbCaseData extends Synchronizable {


    private Integer patientId;

    private String caseNumber;

    private String name;
    private String middleName;
    private String lastName;

    private String motherName;

    private Date birthDate;
    private Integer age;
    private Gender gender;
    private String securityNumber;

    private CaseClassification classification;
    private CaseState state;
    private ValidationState validationState;
    private PatientType patientType;
    private CaseDefinition caseDefinition;
    private DiagnosisType diagnosisType;
    private InfectionSite infectionSite;
    private Nationality nationality;
    private Integer pulmonaryId;
    private Integer extrapulmonaryId;
    private Integer extrapulmonary2Id;
    private boolean movedSecondLineTreatment;

    private Date registrationDate;
    private Date healthunitRegistrationDate;
    private Date diagnosisDate;
    private Date iniTreatmentDate;
    private Date endTreatmentDate;
    private Date outcomeDate;
    private Date iniContinuousPhase;
    private Integer regimenId;
    private Integer regimenIniId;
    private String tbRegistrationNumber;
    private TreatmentCategory treatmentCategory;

    private String address;
    private Integer adminUnitId;
    private String zipCode;

    private String phoneNumber;
    private String mobileNumber;
    private String emailAddress;

    private HIVPosition hivPosition;
    private HIVPositionDetail hivPositionDetail;

    private Boolean intakeAntiTBDrugs;
    private IntakeAntiDrugsDuration intakeAntiTBDrugsDuration;
    private Integer sourceReferralId;
    private Integer dotProvider;
    private Integer maritalStatus;
    private Integer occupation;
    private DrugResistanceType drugResistanceType;

    @Override
    public String toString() {
        return "TbCaseData{" +
                "name='" + name + '\'' +
                ", middleName='" + middleName + '\'' +
                ", lastName='" + lastName + '\'' +
                '}';
    }

    public Integer getPatientId() {
        return patientId;
    }

    public void setPatientId(Integer patientId) {
        this.patientId = patientId;
    }

    public String getCaseNumber() {
        return caseNumber;
    }

    public void setCaseNumber(String caseNumber) {
        this.caseNumber = caseNumber;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getMiddleName() {
        return middleName;
    }

    public void setMiddleName(String middleName) {
        this.middleName = middleName;
    }

    public String getLastName() {
        return lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getMotherName() {
        return motherName;
    }

    public void setMotherName(String motherName) {
        this.motherName = motherName;
    }

    public Date getBirthDate() {
        return birthDate;
    }

    public void setBirthDate(Date birthDate) {
        this.birthDate = birthDate;
    }

    public Integer getAge() {
        return age;
    }

    public void setAge(Integer age) {
        this.age = age;
    }

    public Gender getGender() {
        return gender;
    }

    public void setGender(Gender gender) {
        this.gender = gender;
    }

    public CaseClassification getClassification() {
        return classification;
    }

    public void setClassification(CaseClassification classification) {
        this.classification = classification;
    }

    public CaseState getState() {
        return state;
    }

    public void setState(CaseState state) {
        this.state = state;
    }

    public ValidationState getValidationState() {
        return validationState;
    }

    public void setValidationState(ValidationState validationState) {
        this.validationState = validationState;
    }

    public PatientType getPatientType() {
        return patientType;
    }

    public void setPatientType(PatientType patientType) {
        this.patientType = patientType;
    }

    public CaseDefinition getCaseDefinition() {
        return caseDefinition;
    }

    public void setCaseDefinition(CaseDefinition caseDefinition) {
        this.caseDefinition = caseDefinition;
    }

    public DiagnosisType getDiagnosisType() {
        return diagnosisType;
    }

    public void setDiagnosisType(DiagnosisType diagnosisType) {
        this.diagnosisType = diagnosisType;
    }

    public InfectionSite getInfectionSite() {
        return infectionSite;
    }

    public void setInfectionSite(InfectionSite infectionSite) {
        this.infectionSite = infectionSite;
    }

    public Integer getPulmonaryId() {
        return pulmonaryId;
    }

    public void setPulmonaryId(Integer pulmonaryId) {
        this.pulmonaryId = pulmonaryId;
    }

    public Integer getExtrapulmonaryId() {
        return extrapulmonaryId;
    }

    public void setExtrapulmonaryId(Integer extrapulmonaryId) {
        this.extrapulmonaryId = extrapulmonaryId;
    }

    public Integer getExtrapulmonary2Id() {
        return extrapulmonary2Id;
    }

    public void setExtrapulmonary2Id(Integer extrapulmonary2Id) {
        this.extrapulmonary2Id = extrapulmonary2Id;
    }

    public Date getRegistrationDate() {
        return registrationDate;
    }

    public void setRegistrationDate(Date registrationDate) {
        this.registrationDate = registrationDate;
    }

    public Date getDiagnosisDate() {
        return diagnosisDate;
    }

    public void setDiagnosisDate(Date diagnosisDate) {
        this.diagnosisDate = diagnosisDate;
    }

    public Date getIniTreatmentDate() {
        return iniTreatmentDate;
    }

    public void setIniTreatmentDate(Date iniTreatmentDate) {
        this.iniTreatmentDate = iniTreatmentDate;
    }

    public Date getEndTreatmentDate() {
        return endTreatmentDate;
    }

    public void setEndTreatmentDate(Date endTreatmentDate) {
        this.endTreatmentDate = endTreatmentDate;
    }

    public Date getOutcomeDate() {
        return outcomeDate;
    }

    public void setOutcomeDate(Date outcomeDate) {
        this.outcomeDate = outcomeDate;
    }

    public Date getIniContinuousPhase() {
        return iniContinuousPhase;
    }

    public void setIniContinuousPhase(Date iniContinuousPhase) {
        this.iniContinuousPhase = iniContinuousPhase;
    }

    public Integer getRegimenId() {
        return regimenId;
    }

    public void setRegimenId(Integer regimenId) {
        this.regimenId = regimenId;
    }

    public Integer getRegimenIniId() {
        return regimenIniId;
    }

    public void setRegimenIniId(Integer regimenIniId) {
        this.regimenIniId = regimenIniId;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public Integer getAdminUnitId() {
        return adminUnitId;
    }

    public void setAdminUnitId(Integer adminUnitId) {
        this.adminUnitId = adminUnitId;
    }

    public String getZipCode() {
        return zipCode;
    }

    public void setZipCode(String zipCode) {
        this.zipCode = zipCode;
    }

    public String getPhoneNumber() {
        return phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public String getMobileNumber() {
        return mobileNumber;
    }

    public void setMobileNumber(String mobileNumber) {
        this.mobileNumber = mobileNumber;
    }

    public HIVPosition getHivPosition() {
        return hivPosition;
    }

    public void setHivPosition(HIVPosition hivPosition) {
        this.hivPosition = hivPosition;
    }

    public HIVPositionDetail getHivPositionDetail() {
        return hivPositionDetail;
    }

    public void setHivPositionDetail(HIVPositionDetail hivPositionDetail) {
        this.hivPositionDetail = hivPositionDetail;
    }

    public Boolean getIntakeAntiTBDrugs() {
        return intakeAntiTBDrugs;
    }

    public void setIntakeAntiTBDrugs(Boolean intakeAntiTBDrugs) {
        this.intakeAntiTBDrugs = intakeAntiTBDrugs;
    }

    public IntakeAntiDrugsDuration getIntakeAntiTBDrugsDuration() {
        return intakeAntiTBDrugsDuration;
    }

    public void setIntakeAntiTBDrugsDuration(IntakeAntiDrugsDuration intakeAntiTBDrugsDuration) {
        this.intakeAntiTBDrugsDuration = intakeAntiTBDrugsDuration;
    }

    public Integer getSourceReferralId() {
        return sourceReferralId;
    }

    public void setSourceReferralId(Integer sourceReferralId) {
        this.sourceReferralId = sourceReferralId;
    }

    public String getSecurityNumber() {
        return securityNumber;
    }

    public void setSecurityNumber(String securityNumber) {
        this.securityNumber = securityNumber;
    }

    public String getEmailAddress() {
        return emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public String getTbRegistrationNumber() {
        return tbRegistrationNumber;
    }

    public void setTbRegistrationNumber(String tbRegistrationNumber) {
        this.tbRegistrationNumber = tbRegistrationNumber;
    }

    public Integer getDotProvider() {
        return dotProvider;
    }

    public void setDotProvider(Integer dotProvider) {
        this.dotProvider = dotProvider;
    }

    public TreatmentCategory getTreatmentCategory() {
        return treatmentCategory;
    }

    public void setTreatmentCategory(TreatmentCategory treatmentCategory) {
        this.treatmentCategory = treatmentCategory;
    }

    public Integer getMaritalStatus() {
        return maritalStatus;
    }

    public void setMaritalStatus(Integer maritalStatus) {
        this.maritalStatus = maritalStatus;
    }

    public Integer getOccupation() {
        return occupation;
    }

    public void setOccupation(Integer occupation) {
        this.occupation = occupation;
    }

    public DrugResistanceType getDrugResistanceType() {
        return drugResistanceType;
    }

    public void setDrugResistanceType(DrugResistanceType drugResistanceType) {
        this.drugResistanceType = drugResistanceType;
    }

    public boolean isMovedSecondLineTreatment() {
        return movedSecondLineTreatment;
    }

    public void setMovedSecondLineTreatment(boolean movedSecondLineTreatment) {
        this.movedSecondLineTreatment = movedSecondLineTreatment;
    }

    public Nationality getNationality() {
        return nationality;
    }

    public void setNationality(Nationality nationality) {
        this.nationality = nationality;
    }

    public Date getHealthunitRegistrationDate() {
        return healthunitRegistrationDate;
    }

    public void setHealthunitRegistrationDate(Date healthunitRegistrationDate) {
        this.healthunitRegistrationDate = healthunitRegistrationDate;
    }
}
